<?php

/**
 * Bloque utilizado como contador de visitas
 *
 * @author David Herney Bernal Garca davidherney@gmail.com
 * @author Programa Integracin de tecnologas a la docencia - Universidad de Antioquia
 * @version  $Id: block_contador.php,v 2.0 2009/09/03 10:35:26 dhbernal Exp $
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @package UdeA
 */


class block_contador extends block_base {
    function init() {
        $this->title = get_string('titlecounter', 'block_contador');
        $this->version = 2009090301;
    }
    
    function has_config() {
      return true;
    }

    function get_content() {
        if ($this->content !== NULL) {
            return $this->content;
        }

        global $CFG, $USER;
        $course = get_record('course', 'id', $this->instance->pageid);
		
 		if ($course == NULL || !is_object($course) || $course->id == 0){
			$course->id = (-1) * $USER->id;
		}
 		
        $ip = getremoteaddr();
		
		 //Numero de segundos entre cuentas de una misma IP (86400 = 1 dia)
		if (isset($CFG->block_contador_espera)) {
        	$diferencia = $CFG->block_contador_espera;
		}
		else {
			$diferencia = 14400;
		}

        $sql = "SELECT 1 FROM {$CFG->prefix}counter 
                WHERE course = {$course->id} 
                AND ip = '$ip'
                AND time > " . (time() - $diferencia);
				
        if (!record_exists_sql($sql)) {
            $dataobject->ip = $ip;
            $dataobject->course = $course->id;
            $dataobject->time = time();
            insert_record('counter', $dataobject, false);
        }

        $count = count_records('counter', 'course', $course->id);
        $time = get_record_sql("SELECT MIN(time) AS mintime FROM {$CFG->prefix}counter WHERE course = {$course->id}");
		
        $text = "<div style='text-align: center' >";
        for ($i = 0; $i < strlen($count); $i++){
            $tok = substr ($count, $i, 1);

            if (file_exists($CFG->dataroot . '/' . $course->id . '/contador/' . $tok . '.gif')){
			    if ($CFG->slasharguments) {
                	$filetok = $CFG->wwwroot . '/file.php/' . $course->id . '/contador/' . $tok . '.gif';
                } 
            	else {
            	    $filetok = $CFG->wwwroot . '/file.php?file=/' . $course->id . '/contador/' . $tok . '.gif';
                } 
            }
			else {
                $filetok = $CFG->wwwroot . '/blocks/contador/pix/' . $tok . '.gif';
            }

            $text .= "<img src='$filetok' alt='$tok' />";
        }
        $text .= "</div>";

        $formatdate = strftime(get_string('strftimedate'), $time->mintime);
		
        $this->content = new stdClass;
        $this->content->text = $text;
        $this->content->footer = get_string('timecounter', 'block_contador') . $formatdate;
    
        return $this->content;
    }

}

?>