<?php

require_once($CFG->libdir.'/formslib.php');

class config_menutopic_form extends moodleform {

    function definition() {
        global $USER, $CFG, $course;

		$config = new object();
		$config->jsdefault = true;
		$config->cssdefault = true;
		$config->usehtml = false;
		$config->menuposition = 'middle';
		$config->linkinparent = false;
		$config->templatetopic = false;
		$config->icons_templatetopic = false;
		$config->displaynousedmod = false;

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME)) {
			$values = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME);
			$config = unserialize($values);
			
			if (!is_object($config)) {
				$config = new object();
			}
			
			if (!isset($config->jsdefault)) {
				$config->jsdefault = true;
			}

			if (!isset($config->cssdefault)) {
				$config->cssdefault = true;
			}

			if (!isset($config->usehtml)) {
				$config->usehtml = false;
			}

			if (!isset($config->menuposition)) {
				$config->menuposition = 'middle';
			}
			
			if (!isset($config->linkinparent)) {
				$config->linkinparent = false;
			}
			
			if (!isset($config->templatetopic)) {
				$config->templatetopic = false;
			}

			if (!isset($config->icons_templatetopic)) {
				$config->icons_templatetopic = false;
			}

			if (!isset($config->displaynousedmod)) {
				$config->displaynousedmod = false;
			}

			if (!isset($config->displaynavigation)) {
				$config->displaynavigation = 'nothing';
			}

			if (!isset($config->nodesnavigation)) {
				$config->nodesnavigation = '';
			}
		}

        $mform =& $this->_form;
		
        $mform->addElement('header','general', get_string('config_editmenu_title', 'format_menutopic'));

        $mform->addElement('selectyesno', 'jsdefault', get_string('jsdefault', 'format_menutopic'));
        $mform->setHelpButton('jsdefault', array('format_menutopic_jsdefault', get_string('jsdefault', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('jsdefault', $config->jsdefault);

        $mform->addElement('selectyesno', 'cssdefault', get_string('cssdefault', 'format_menutopic'));
        $mform->setHelpButton('cssdefault', array('format_menutopic_cssdefault', get_string('cssdefault', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('cssdefault', $config->cssdefault);

        $mform->addElement('selectyesno', 'usehtml', get_string('usehtml', 'format_menutopic'));
        $mform->setHelpButton('usehtml', array('format_menutopic_usehtml', get_string('usehtml', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('usehtml', $config->usehtml);

        $choices = array();
        $choices['hide'] = get_string('menuposition_hide', 'format_menutopic');
        $choices['left'] = get_string('menuposition_left', 'format_menutopic');
        $choices['middle'] = get_string('menuposition_middle', 'format_menutopic');
        $choices['right'] = get_string('menuposition_right', 'format_menutopic');
        $mform->addElement('select', 'menuposition', get_string('menuposition', 'format_menutopic'), $choices);
        $mform->setHelpButton('menuposition', array('format_menutopic_menuposition', get_string('menuposition', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('menuposition', $config->menuposition);

        $mform->addElement('selectyesno', 'linkinparent', get_string('linkinparent', 'format_menutopic'));
        $mform->setHelpButton('linkinparent', array('format_menutopic_linkinparent', get_string('linkinparent', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('linkinparent', $config->linkinparent);

        $choices = array();
        $choices['top'] = get_string('navigationposition_top', 'format_menutopic');
        $choices['bottom'] = get_string('navigationposition_bottom', 'format_menutopic');
        $choices['both'] = get_string('navigationposition_both', 'format_menutopic');
        $choices['nothing'] = get_string('navigationposition_nothing', 'format_menutopic');
        $mform->addElement('select', 'displaynavigation', get_string('displaynavigation', 'format_menutopic'), $choices);
        $mform->setHelpButton('displaynavigation', array('format_menutopic_displaynavigation', get_string('displaynavigation', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('displaynavigation', $config->displaynavigation);

        $mform->addElement('text', 'nodesnavigation', get_string('nodesnavigation', 'format_menutopic'));
        $mform->setHelpButton('nodesnavigation', array('format_menutopic_nodesnavigation', get_string('nodesnavigation', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('nodesnavigation', $config->nodesnavigation);

        $mform->addElement('header','template_topic', get_string('config_template_topic_title', 'format_menutopic'));

		$mform->addElement('selectyesno', 'templatetopic', get_string('templatetopic', 'format_menutopic'));
        $mform->setHelpButton('templatetopic', array('format_menutopic_templatetopic', get_string('templatetopic', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('templatetopic', $config->templatetopic);

        $mform->addElement('selectyesno', 'icons_templatetopic', get_string('icons_templatetopic', 'format_menutopic'));
        $mform->setHelpButton('icons_templatetopic', array('format_menutopic_icons_templatetopic', get_string('icons_templatetopic', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('icons_templatetopic', $config->icons_templatetopic);

        $mform->addElement('selectyesno', 'displaynousedmod', get_string('displaynousedmod', 'format_menutopic'));
        $mform->setHelpButton('displaynousedmod', array('format_menutopic_displaynousedmod', get_string('displaynousedmod', 'format_menutopic'), 'format_menutopic'), true);
        $mform->setDefault('displaynousedmod', $config->displaynousedmod);

        $mform->addElement('hidden', 'id', $course->id);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'topic', '-2');
        $mform->setType('topic', PARAM_INT);

        $mform->addElement('hidden', 'menuaction', 'config');
        $mform->setType('menuaction', PARAM_ALPHA);

		$this->add_action_buttons();
    }
}

$display_form = new config_menutopic_form('view.php');

if ($display_form->is_cancelled()){
	redirect($CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=0');
}
else if ($data = $display_form->get_data()) {
	$data->wwwroot = $CFG->wwwroot;
	$data->courseid = $course->id;
	$values = serialize($data);
	if (!file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME, $values)){
        notify (get_string('notsaved', 'format_menutopic'));
	}
	else {
        notify (get_string('savecorrect', 'format_menutopic'));
	}
}

$display_form->display();

?>