<?php

require_once($CFG->libdir.'/formslib.php');

class csstemplate_menutopic_form extends moodleform {

    function definition() {
        global $USER, $CFG, $course;

		$csscode = '';

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME)) {
			$csscode = stripslashes(file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME));
		}

        $mform =& $this->_form;
		
        $mform->addElement('header','general', get_string('csstemplate_editmenu_title', 'format_menutopic'));
        $mform->setHelpButton('general', array('format_menutopic_csstemplate', get_string('csstemplate_editmenu_title', 'format_menutopic'), 'format_menutopic'), true);

        $mform->addElement('textarea','csscode', get_string('csscode', 'format_menutopic'), array('rows'=> '20', 'cols'=>'65'));
        $mform->setType('csscode', PARAM_RAW);
		$mform->setDefault('csscode', $csscode);

        $mform->addElement('hidden', 'id', $course->id);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'topic', '-2');
        $mform->setType('topic', PARAM_INT);

        $mform->addElement('hidden', 'menuaction', 'csstemplate');
        $mform->setType('menuaction', PARAM_ALPHA);

		$this->add_action_buttons();
    }
}

$display_form = new csstemplate_menutopic_form('view.php');

if ($display_form->is_cancelled()){
	redirect($CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=0');
}
else if ($data = $display_form->get_data()) {
	$code_css = stripcslashes($data->csscode);

	if (!file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME, $code_css)){
        notify (get_string('notsaved', 'format_menutopic'));
	}
	else {
        notify (get_string('savecorrect', 'format_menutopic'));
	}
}

$display_form->display();

?>