<?php

require_once($CFG->libdir.'/formslib.php');

class htmltemplate_menutopic_form extends moodleform {

    function definition() {
        global $USER, $CFG, $course;

		$htmlcode = '';

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME)) {
			$htmlcode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME);
		}

        $mform =& $this->_form;
		
        $mform->addElement('header','general', get_string('htmltemplate_editmenu_title', 'format_menutopic'));
        $mform->setHelpButton('general', array('format_menutopic_htmltemplate', get_string('htmltemplate_editmenu_title', 'format_menutopic'), 'format_menutopic'), true);

        $mform->addElement('htmleditor','htmlcode', get_string('htmlcode', 'format_menutopic'), array('rows'=> '20', 'cols'=>'65', 'course'=>$course->id));
        $mform->setHelpButton('htmlcode', array('text', get_string('helptext')), true);
        $mform->setType('htmlcode', PARAM_RAW);
		$mform->setDefault('htmlcode', $htmlcode);

        $mform->addElement('hidden', 'id', $course->id);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'topic', '-2');
        $mform->setType('topic', PARAM_INT);

        $mform->addElement('hidden', 'menuaction', 'htmltemplate');
        $mform->setType('menuaction', PARAM_ALPHA);

		$this->add_action_buttons();
    }
}

$display_form = new htmltemplate_menutopic_form('view.php');

if ($display_form->is_cancelled()){
	redirect($CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=0');
}
else if ($data = $display_form->get_data()) {
	$code_html = stripcslashes($data->htmlcode);

	if (!file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME, $code_html)){
        notify (get_string('notsaved', 'format_menutopic'));
	}
	else {
		//Delete html cache if exists
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME)) {
			unlink(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME);
		}
        notify (get_string('savecorrect', 'format_menutopic'));
	}
}

$display_form->display();

?>