<?php

require_once($CFG->libdir.'/formslib.php');

class jstemplate_menutopic_form extends moodleform {

    function definition() {
        global $USER, $CFG, $course;

		$jscode = '';

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_JS_NAME)) {
			$jscode = stripslashes(file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_JS_NAME));
		}

        $mform =& $this->_form;
		
        $mform->addElement('header','general', get_string('jstemplate_editmenu_title', 'format_menutopic'));
        $mform->setHelpButton('general', array('format_menutopic_jstemplate', get_string('jstemplate', 'format_menutopic'), 'format_menutopic'), true);

        $mform->addElement('textarea','jscode', get_string('jscode', 'format_menutopic'), array('rows'=> '20', 'cols'=>'65'));
        $mform->setType('jscode', PARAM_RAW);
		$mform->setDefault('jscode', $jscode);

        $mform->addElement('hidden', 'id', $course->id);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'topic', '-2');
        $mform->setType('topic', PARAM_INT);

        $mform->addElement('hidden', 'menuaction', 'jstemplate');
        $mform->setType('menuaction', PARAM_ALPHA);

		$this->add_action_buttons();
    }
}

$display_form = new jstemplate_menutopic_form('view.php');

if ($display_form->is_cancelled()){
	redirect($CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=0');
}
else if ($data = $display_form->get_data()) {
	$code_js = stripcslashes($data->jscode);

	if (!file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_JS_NAME, $code_js)){
        notify (get_string('notsaved', 'format_menutopic'));
	}
	else {
        notify (get_string('savecorrect', 'format_menutopic'));
	}
}

$display_form->display();

?>