<?php

require_once($CFG->libdir.'/formslib.php');

class tree_menutopic_form extends moodleform {

    function definition() {
        global $USER, $CFG, $course;

		require_js(array('yui_yahoo', 'yui_event', 'yui_json', 'yui_dom', 'yui_treeview', 'yui_container', 'yui_dragdrop', $CFG->wwwroot . "/course/format/menutopic/lib.js"));
		
		$treecode = '';

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_TREE_NAME)) {
			$treecode = stripslashes(file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_TREE_NAME));
		}
		else {
			$treecode = '{"topics": [';
			for ($i = 0; $i < ($course->numsections + 1); $i++){
				$treecode .= '{"name" : "' . get_string('template_namemenutopic', 'format_menutopic', $i) . '",';
				$treecode .= '         "subtopics": [],';
				$treecode .= '         "topicnumber": ' . $i . ',';
				$treecode .= '         "url": "",';
				$treecode .= '         "target": ""';
				$treecode .= "},\n";
			}
			$treecode .= ']}';
		}

        $mform =& $this->_form;

        $mform->addElement('header','general', get_string('tree_editmenu_title', 'format_menutopic'));
        $mform->setHelpButton('general', array('format_menutopic_treemenu', get_string('tree_editmenu_title', 'format_menutopic'), 'format_menutopic'), true);

        $mform->addElement('textarea','treecode', get_string('tree_struct', 'format_menutopic'), array('style'=>'display:none'));
//        $mform->addElement('textarea','treecode', '', array('rows'=>'40', 'cols'=>'200'));
        $mform->setType('treecode', PARAM_RAW);
		$mform->setDefault('treecode', $treecode);

        $mform->addElement('text', 'sections', '', array('style'=>'display:none'));
        $mform->setType('sections', PARAM_INT);
		$mform->setDefault('sections', ($course->numsections + 1));

        $mform->addElement('hidden', 'id', $course->id);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'topic', '-2');
        $mform->setType('topic', PARAM_INT);

        $mform->addElement('hidden', 'menuaction', 'tree');
        $mform->setType('menuaction', PARAM_ALPHA);

		$this->add_action_buttons();
    }
}

$display_form = new tree_menutopic_form('view.php');

if ($display_form->is_cancelled()){
	redirect($CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=0');
}
else if ($data = $display_form->get_data()) {
	if (!file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_TREE_NAME, $data->treecode)){
        notify (get_string('notsaved', 'format_menutopic'));
	}
	else {
		//Delete html cache if exists
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME)) {
			unlink(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME);
		}
        notify (get_string('savecorrect', 'format_menutopic'));
	}
}

$display_form->display();

?>
<style>
	.ygtvlabel {
		cursor: pointer;
	}

	.input_edit_control {
		border: 1px solid #CCC;
		background-color: #FFF;
	}
	
	.select_topics{
		border: solid 1px #FFF;
	}
	
	.img_action {
		cursor: pointer;
		margin-right: 10px;
	}
	
</style>
<link type="text/css" rel="stylesheet" href="<?php echo $CFG->wwwroot; ?>/lib/yui/assets/skins/sam/treeview.css" />
<div id="tree_container"><!--El div debe estar antes del script para que pueda ser referenciado como contenedor del árbol --></div>
<script language="javascript" type="text/javascript">
	var _SHEETS = new Array();
	var _GLOBAL_VARS = new Array();

	if (!load_tree('id_treecode')) {
		alert("<?php print_string('error_jsontree', 'format_menutopic'); ?>");
	}
	
//	var panel_properties = new YAHOO.widget.Panel("panel_edit_sheet", { width:"320px", visible:true, constraintoviewport:true } ); 
	YAHOO.namespace("tree_admin");

	function init() {
		// Instantiate a Panel from markup
		YAHOO.tree_admin.panel_edit_sheet = new YAHOO.widget.Panel("panel_edit_sheet", { visible:false, draggable:false } );
		YAHOO.tree_admin.panel_edit_sheet.render();
	}

	YAHOO.util.Event.addListener(window, "load", init);
	
	YAHOO.util.Event.addListener('id_submitbutton', "click", save_tree_config);
	
</script>
<div id="panel_container_editsheet" class="yui-skin-sam">
    <div id="panel_edit_sheet">
        <div class="hd"><?php print_string('title_panel_sheetedit', 'format_menutopic'); ?></div> 
        <div class="bd">
            <table cellpadding="0" cellspacing="0">
            	<tr>
                    <th><?php print_string('actions_sheet_sheetedit', 'format_menutopic'); ?></th>
                    <td>
                    	&nbsp;&nbsp;
                    	<img onclick="move_sheet_left()" id="btn_move_left_sheet" class="img_action" src="<?php echo $CFG->pixpath;?>/t/left.gif" alt="<?php print_string('actionleft_sheet_sheetedit', 'format_menutopic'); ?>" title="<?php print_string('actionleft_sheet_sheetedit', 'format_menutopic'); ?>" />
                    	<img onclick="move_sheet_right()" id="btn_move_right_sheet" class="img_action" src="<?php echo $CFG->pixpath;?>/t/right.gif" alt="<?php print_string('actionright_sheet_sheetedit', 'format_menutopic'); ?>" title="<?php print_string('actionright_sheet_sheetedit', 'format_menutopic'); ?>" />
                    	<img onclick="move_sheet_up()" id="btn_move_up_sheet" class="img_action" src="<?php echo $CFG->pixpath;?>/t/up.gif" alt="<?php print_string('actionup_sheet_sheetedit', 'format_menutopic'); ?>" title="<?php print_string('actionup_sheet_sheetedit', 'format_menutopic'); ?>" />
                    	<img onclick="move_sheet_down()" id="btn_move_down_sheet" class="img_action" src="<?php echo $CFG->pixpath;?>/t/down.gif" alt="<?php print_string('actiondown_sheet_sheetedit', 'format_menutopic'); ?>" title="<?php print_string('actiondown_sheet_sheetedit', 'format_menutopic'); ?>" />
                    	<img class="img_action" id="btn_delete_sheet" src="<?php echo $CFG->pixpath;?>/t/delete.gif" alt="<?php print_string('actiondelete_sheet_sheetedit', 'format_menutopic'); ?>" title="<?php print_string('actiondelete_sheet_sheetedit', 'format_menutopic'); ?>" onclick="if(confirm('<?php print_string('actiondeleteconfirm_sheet_sheetedit', 'format_menutopic'); ?>')){ delete_sheet();}" />
                    </td>
                </tr>
                <tr>
                    <th><?php print_string('name_sheet_sheetedit', 'format_menutopic'); ?></th>
                    <td><input id="name_text" size="20" class="input_edit_control" /></td>
                </tr>
                <tr>
                    <th><?php print_string('topic_sheet_sheetedit', 'format_menutopic'); ?></th>
                    <td>
                        <select id="select_topic" onchange="change_topic(this)">
                            <option></option>
                        <?php
                            for ($i = 0; $i < ($course->numsections + 1); $i++) {
                                echo '<option>' . $i . '</option>';
                            }
                        ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th><?php print_string('url_sheet_sheetedit', 'format_menutopic'); ?></th>
                    <td><input id="url_text" size="40" class="input_edit_control" /></td>
                </tr>
                <tr>
                    <th><?php print_string('target_sheet_sheetedit', 'format_menutopic'); ?></th>
                    <td>
                        <select id="select_target">
                            <option></option>
                            <option value="_blank"><?php print_string('targetblank_sheet_sheetedit', 'format_menutopic'); ?></option>
                            <option value="_self"><?php print_string('targetself_sheet_sheetedit', 'format_menutopic'); ?></option>
                        </select>
                    </td>
                </tr>
	            <tr>
                	<td colspan="2">
                    	<input type="button" onclick="change_sheet()" value="<?php print_string('actionsave_sheet_sheetedit', 'format_menutopic'); ?>" />
                    	<input type="button" onclick="add_sheet_daughter()" value="<?php print_string('actionadd_sheet_daughter_sheetedit', 'format_menutopic'); ?>" />
                    	<input type="button" onclick="add_sheet_sister()" value="<?php print_string('actionadd_sheet_sister_sheetedit', 'format_menutopic'); ?>" />
                    </td>
                </tr>
            </table>
        </div>
        <div class="ft"></div>
    </div>
</div>