<?php // $Id: format.php,v 1.0.0.0 2010/04/16 17:10:00 cirano Exp $
      // Muestra los temas partiendio de un menu en la parte superior del curso
	  // Es una modificación del formato "topics" original de moodle

	if ($CFG->slasharguments){
		define('URL_FORMAT_FILES', $CFG->wwwroot . '/file.php/' . $course->id . '/format_menutopic');
	} else {
		define('URL_FORMAT_FILES', $CFG->wwwroot . '/file.php?file=/' . $course->id . '/format_menutopic');
	}

	define('PATH_FORMAT_SAVE', $CFG->dataroot . '/' . $course->id . '/format_menutopic');
	define('FILE_CONFIG_NAME', 'menutopic.cfg');
	define('FILE_CSS_NAME', 'menutopic.css');
	define('FILE_JS_NAME', 'menutopic.js');
	define('FILE_HTML_NAME', 'menutopic.tpl');
	define('FILE_HTML_CACHE_NAME', 'menutopic.cache.tpl');
	define('FILE_TREE_NAME', 'menutopic.tree');


    require_once($CFG->libdir.'/ajax/ajaxlib.php');
  
    $topic = optional_param('topic', -1, PARAM_INT);

    // Bounds for block widths
    // more flexible for theme designers taken from theme config.php
    $lmin = (empty($THEME->block_l_min_width)) ? 100 : $THEME->block_l_min_width;
    $lmax = (empty($THEME->block_l_max_width)) ? 210 : $THEME->block_l_max_width;
    $rmin = (empty($THEME->block_r_min_width)) ? 100 : $THEME->block_r_min_width;
    $rmax = (empty($THEME->block_r_max_width)) ? 210 : $THEME->block_r_max_width;

    define('BLOCK_L_MIN_WIDTH', $lmin);
    define('BLOCK_L_MAX_WIDTH', $lmax);
    define('BLOCK_R_MIN_WIDTH', $rmin);
    define('BLOCK_R_MAX_WIDTH', $rmax);

    $preferred_width_left  = bounded_number(BLOCK_L_MIN_WIDTH, blocks_preferred_width($pageblocks[BLOCK_POS_LEFT]),  
                                            BLOCK_L_MAX_WIDTH);
    $preferred_width_right = bounded_number(BLOCK_R_MIN_WIDTH, blocks_preferred_width($pageblocks[BLOCK_POS_RIGHT]), 
                                            BLOCK_R_MAX_WIDTH);

    if ($topic != -1) {
		if ($topic == -2 && !$PAGE->user_allowed_editing()) {
			$topic = 0;
		}
        $displaysection = course_set_display($course->id, $topic);
    } else {
        if (isset($USER->display[$course->id])) {       // for admins, mostly
            $displaysection = $USER->display[$course->id];
        } else {
            $displaysection = course_set_display($course->id, 0);
        }
    }
	
	$editable_format = true;

	// Valida si existe el directorio donde se almacenan los datos de configuración del menú. Si no existe lo crea.
	// Si no lo puede crear no permite pasar a modo edición
	if (!file_exists(PATH_FORMAT_SAVE)){
		$new_path = str_replace($CFG->dataroot . '/', '', PATH_FORMAT_SAVE);
		if (!make_upload_directory($new_path)) {
	        $editable_format = false;
		}
	}
	
    $context = get_context_instance(CONTEXT_COURSE, $course->id);

    if (($marker >=0) && has_capability('moodle/course:setcurrentsection', $context) && confirm_sesskey()) {
        $course->marker = $marker;
        if (! set_field("course", "marker", $marker, "id", $course->id)) {
            error("Could not mark that topic for this course");
        }
    }

    $streditsummary   = get_string('editsummary');
    $stradd           = get_string('add');
    $stractivities    = get_string('activities');
    $strshowalltopics = get_string('showalltopics');
    $strtopic         = get_string('topic');
    $strgroups        = get_string('groups');
    $strgroupmy       = get_string('groupmy');
    $streditmenu      = get_string('editmenu', 'format_menutopic');
    $strendeditmenu   = get_string('end_editmenu', 'format_menutopic');
    $editing          = $PAGE->user_is_editing();

    if ($editing) {
        $strstudents = moodle_strtolower($course->students);
        $strtopichide = get_string('topichide', '', $strstudents);
        $strtopicshow = get_string('topicshow', '', $strstudents);
        $strmarkthistopic = get_string('markthistopic');
        $strmarkedthistopic = get_string('markedthistopic');
        $strmoveup = get_string('moveup');
        $strmovedown = get_string('movedown');
    }


/// Layout the whole page as three big columns.
    echo '<table id="layout-table" cellspacing="0" summary="'.get_string('layouttable').'"><tr>';
	
	

/*mover una rama con hijos hace que se pierdan los hijos*/


	if ($displaysection != -2) {
		//Vars needs for configuration of menu layout
		$configMenu = new object();
		$configMenu->jsdefault = true;
		$configMenu->cssdefault = true;
		$configMenu->menuposition = 'middle';
		$configMenu->displaynousedmod = false;
		$configMenu->templatetopic = false;
		$print_for_menu = '';

//Params to configuration
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME)) {
			$values = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME);
			$configMenu = unserialize($values);
			
			if (!is_object($configMenu)) {
				$configMenu = new object();
			}
			
			if (!isset($configMenu->jsdefault)) {
				$configMenu->jsdefault = true;
			}

			if (!isset($configMenu->cssdefault)) {
				$configMenu->cssdefault = true;
			}

			if (!isset($configMenu->menuposition)) {
				$configMenu->menuposition = 'middle';
			}
			
			if (!isset($configMenu->displaynousedmod)) {
				$configMenu->displaynousedmod = false;
			}
			
			if (!isset($configMenu->templatetopic)) {
				$configMenu->templatetopic = false;
			}

			if (!isset($configMenu->displaynavigation)) {
				$configMenu->displaynavigation = 'nothing';
			}
			
			if ((!isset($configMenu->wwwroot) || $configMenu->wwwroot != $CFG->wwwroot) ||
					(!isset($configMenu->courseid) || $configMenu->courseid != $course->id)) {

				if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME)) {
					@unlink(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME);
				}

				require_once $CFG->dirroot . '/course/format/menutopic/menu.php';
				$menu = new format_menutopic_menu();
				$menu->fix_urls($configMenu);

			}

		}
			
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_TREE_NAME)) { //building menu
			$treecode = stripslashes(file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_TREE_NAME));

			if ($configMenu->menuposition != 'hide') {
				require_once $CFG->dirroot . '/course/format/menutopic/menu.php';
				
				$menu = new format_menutopic_menu();
				$menu->treecode = $treecode;
				
				if ($configMenu->cssdefault) {
					$print_for_menu .= '<link rel="stylesheet" type="text/css" href="'.$CFG->wwwroot.'/lib/yui/menu/assets/menu.css" />';
					$print_for_menu .= '<link rel="stylesheet" type="text/css" href="'.$CFG->wwwroot.'/course/format/menutopic/style.css" />';
				}
	
				require_js(array('yui_yahoo', 'yui_json', 'yui_event', 'yui_dom', 'yui_container', 'yui_dom-event', 
								 'yui_menu', 'yui_connection', 
								 'yui_animation'));
	
				if ($configMenu->jsdefault) {
					require_js(array($CFG->wwwroot . "/course/format/menutopic/courselib.js"));
				}
	
				if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME)) {
					$print_for_menu .= '<link rel="stylesheet" type="text/css" href="'. URL_FORMAT_FILES . '/' . FILE_CSS_NAME . '" />';
				}
	
				//Container and js code for load the menu
				$print_for_menu .= $menu->script_menu($configMenu);

				if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_JS_NAME)) {
					$print_for_menu .= '<script language="javascript" type="text/javascript" src="'. URL_FORMAT_FILES . '/' . FILE_JS_NAME . '"></script>';
				}
	
			}
		}

		if ($configMenu->displaynavigation != 'nothing') {
			$links_navigation = '<span class="%s"><a href="%s/course/view.php?id=%s&topic=%s">%s</a></span>';
			
			$string_previous  = get_string('previous_topic', 'format_menutopic');
			$string_next      = get_string('next_topic', 'format_menutopic');
			$string_separator = get_string('separator_navigation', 'format_menutopic');
			
			if (empty($configMenu->nodesnavigation)) {
				$previous_topic = $displaysection > 0 ? $displaysection - 1 : null;
				$next_topic = $displaysection < $course->numsections ? $displaysection + 1 : null;
			}
			else {
				$ids_topics = explode(',', $configMenu->nodesnavigation);

				$pos = 0;
				foreach($ids_topics as $id_topic) {
					if (trim($id_topic) == $displaysection) {
						break;
					}
					$pos++;
				}
				
				if ($pos >= count($ids_topics)) {
					$previous_topic = $next_topic = null;
				}
				else if ($pos == 0) {
					$previous_topic = null;
					$next_topic = $ids_topics[1];
				}
				else if ($pos == (count($ids_topics) - 1)) {
					$previous_topic = $ids_topics[$pos - 1];
					$next_topic = null;
				}
				else {
					$previous_topic = $ids_topics[$pos - 1];
					$next_topic = $ids_topics[$pos + 1];
				}
			}
			
			$print_for_navigation = '<div class="format_menutopic_navigationbar">';
			
			if ($previous_topic !== null) {
				$print_for_navigation .= sprintf($links_navigation, 
											'format_menutopic_previustopic', $CFG->wwwroot, $course->id, $previous_topic, $string_previous);
			}
			
			if ($previous_topic !== null && $next_topic !== null) {
				$print_for_navigation .= '<span class="format_menutopic_separator">' . $string_separator . '</span>';
			}
			
			if ($next_topic !== null) {
				$print_for_navigation .= sprintf($links_navigation, 
											'format_menutopic_nexttopic', $CFG->wwwroot, $course->id, $next_topic, $string_next);
			}
			$print_for_navigation .= '</div>';
		}
	/// The left column ...
		$lt = (empty($THEME->layouttable)) ? array('left', 'middle', 'right') : $THEME->layouttable;
		foreach ($lt as $column) {
			switch ($column) {
				case 'left':
					if (!empty($print_for_menu) || (blocks_have_content($pageblocks, BLOCK_POS_LEFT) || $editing)) {
						echo '<td style="width:'.$preferred_width_left.'px" id="left-column">';
						print_container_start();

						if ($configMenu->menuposition == 'left') {
							echo $print_for_menu;
						}

						if ((blocks_have_content($pageblocks, BLOCK_POS_LEFT) || $editing)) {
							blocks_print_group($PAGE, $pageblocks, BLOCK_POS_LEFT);
						}

						print_container_end();
						echo '</td>';
					}
				break;
				case 'middle':
					/// Start main column
					echo '<td id="middle-column">';
					print_container_start();
				
					//Activa la edición de la configuración del menú
					if ($editing) {
						print_container_start();
						echo '<form method="get">';
						echo '<input type="submit" value="' . $streditmenu . '" />';
						echo '<input type="hidden" value="-2" name="topic" />';
						echo '<input type="hidden" value="' . $course->id . '" name="id" />';
						echo '</form>';
						print_container_end();
					}
					
					if ($configMenu->menuposition == 'middle') {
						echo $print_for_menu;
					}
					
					if (isset($configMenu->displaynavigation) && ($configMenu->displaynavigation == 'top' || $configMenu->displaynavigation == 'both')) {
						echo $print_for_navigation;
					}
	
					echo skip_main_destination();
				
					echo '<table class="topics" width="100%" summary="'.get_string('layouttable').'">';
				
					/// If currently moving a file then show the current clipboard
					if (ismoving($course->id)) {
						$stractivityclipboard = strip_tags(get_string('activityclipboard', '', addslashes($USER->activitycopyname)));
						$strcancel= get_string('cancel');
						echo '<tr class="clipboard">';
						echo '<td colspan="3">';
						echo $stractivityclipboard.'&nbsp;&nbsp;(<a href="mod.php?cancelcopy=true&amp;sesskey='.$USER->sesskey.'">'.$strcancel.'</a>)';
						echo '</td>';
						echo '</tr>';
					}

					$section = $displaysection;
					if ($section <= $course->numsections) {
				
						if (!empty($sections[$section])) {
							$thissection = $sections[$section];
				
						} else if ($section >= 0) {
							unset($thissection);
							$thissection->course = $course->id;   // Create a new section structure
							$thissection->section = $section;
							$thissection->summary = '';
							$thissection->visible = 1;
							if (!$thissection->id = insert_record('course_sections', $thissection)) {
								notify('Error inserting new topic!');
							}
						}
				
						$showsection = (has_capability('moodle/course:viewhiddensections', $context) or $thissection->visible or !$course->hiddensections);
				
						if ($showsection) {
				
							$currenttopic = ($course->marker == $section);
				
							$currenttext = '';
							if (!$thissection->visible) {
								$sectionstyle = ' hidden';
							} else if ($currenttopic) {
								$sectionstyle = ' current';
								$currenttext = get_accesshide(get_string('currenttopic','access'));
							} else {
								$sectionstyle = '';
							}
				
							echo '<tr id="section-'.$section.'" class="section main'.$sectionstyle.'">';
							echo '<td class="left side">'.$currenttext.$section.'</td>';
				
							echo '<td class="content">';
							if (!has_capability('moodle/course:viewhiddensections', $context) and !$thissection->visible) {   // Hidden for students
								echo get_string('notavailable');
							} else {
								echo '<div class="summary">';
								
								if ($configMenu->templatetopic == true) {
									//Changes to personal page
									include_once $CFG->dirroot . '/course/format/menutopic/sectionlib.php';
									$changed_mods = $mods;
									$summary = format_personalsection_replace_resources ($thissection->summary, $configMenu, $course, $thissection, $changed_mods, $modnamesused);
								}
								else {
									$summary = $thissection->summary;
								}
								
								$summaryformatoptions->noclean = true;
								echo format_text($summary, FORMAT_HTML, $summaryformatoptions);
				
								if (isediting($course->id) && has_capability('moodle/course:update', get_context_instance(CONTEXT_COURSE, $course->id))) {
									echo ' <a title="'.$streditsummary.'" href="editsection.php?id='.$thissection->id.'">'.
										 '<img src="'.$CFG->pixpath.'/t/edit.gif" alt="'.$streditsummary.'" /></a><br /><br />';
								}
								echo '</div>';

								if ($configMenu->templatetopic == false || isediting($course->id)) {
									print_section($course, $thissection, $mods, $modnamesused);
								}
								else if ($configMenu->displaynousedmod == true) {
									print_section($course, $thissection, $changed_mods, $modnamesused);
								}

								if (isediting($course->id)) {
									print_section_add_menus($course, $section, $modnames);
								}
							}
							echo '</td>';
				
							echo '<td class="right side">';
							
							//La siguiente línea se necesita para reemplazar el nodo anterior, de mostrar uno/todos los topicos, de manera que las
							//librerías de AJAX no requieran cambios, ya que estas buscan para las otras operaciones a partir de la segunda posición
							echo "&nbsp;";
				
							if (isediting($course->id) && has_capability('moodle/course:update', get_context_instance(CONTEXT_COURSE, $course->id))) {
								if ($course->marker == $section) {  // Show the "light globe" on/off
									echo '<a href="view.php?id='.$course->id.'&amp;marker=0&amp;sesskey='.$USER->sesskey.'#section-'.$section.'" title="'.$strmarkedthistopic.'">'.
										 '<img src="'.$CFG->pixpath.'/i/marked.gif" alt="'.$strmarkedthistopic.'" /></a><br />';
								} else {
									echo '<a href="view.php?id='.$course->id.'&amp;marker='.$section.'&amp;sesskey='.$USER->sesskey.'#section-'.$section.'" title="'.$strmarkthistopic.'">'.
										 '<img src="'.$CFG->pixpath.'/i/marker.gif" alt="'.$strmarkthistopic.'" /></a><br />';
								}
				
								if ($thissection->visible) {        // Show the hide/show eye
									echo '<a href="view.php?id='.$course->id.'&amp;hide='.$section.'&amp;sesskey='.$USER->sesskey.'#section-'.$section.'" title="'.$strtopichide.'">'.
										 '<img src="'.$CFG->pixpath.'/i/hide.gif" alt="'.$strtopichide.'" /></a><br />';
								} else {
									echo '<a href="view.php?id='.$course->id.'&amp;show='.$section.'&amp;sesskey='.$USER->sesskey.'#section-'.$section.'" title="'.$strtopicshow.'">'.
										 '<img src="'.$CFG->pixpath.'/i/show.gif" alt="'.$strtopicshow.'" /></a><br />';
								}
				
								if ($section > 1) {                       // Add a arrow to move section up
									echo '<a href="view.php?id='.$course->id.'&amp;random='.rand(1,10000).'&amp;section='.$section.'&amp;move=-1&amp;sesskey='.$USER->sesskey.'#section-'.($section-1).'" title="'.$strmoveup.'">'.
										 '<img src="'.$CFG->pixpath.'/t/up.gif" alt="'.$strmoveup.'" /></a><br />';
								}
				
								if ($section < $course->numsections) {    // Add a arrow to move section down
									echo '<a href="view.php?id='.$course->id.'&amp;random='.rand(1,10000).'&amp;section='.$section.'&amp;move=1&amp;sesskey='.$USER->sesskey.'#section-'.($section+1).'" title="'.$strmovedown.'">'.
										 '<img src="'.$CFG->pixpath.'/t/down.gif" alt="'.$strmovedown.'" /></a><br />';
								}
				
							}
				
							echo '</td></tr>';
							echo '<tr class="section separator"><td colspan="3" class="spacer"></td></tr>';
						}
				
					}

					echo '</table>';
		
					print_container_end();

					if (isset($configMenu->displaynavigation) && ($configMenu->displaynavigation == 'bottom' || $configMenu->displaynavigation == 'both')) {
						echo $print_for_navigation;
					}

					echo '</td>';
	
				break;
				case 'right':
					// The right column
					if ((blocks_have_content($pageblocks, BLOCK_POS_RIGHT) || $editing)) {
						echo '<td style="width:'.$preferred_width_right.'px" id="right-column">';
						print_container_start();

						if ($configMenu->menuposition == 'right') {
							echo $print_for_menu;
						}

						blocks_print_group($PAGE, $pageblocks, BLOCK_POS_RIGHT);
						print_container_end();
						echo '</td>';
					}
	
				break;
			}
		}
	} //Fin de si no esta editando el menu
	else { //En edicion del menu
		echo '<td id="middle-column">';
		print_container_start();
		echo '<form method="get">';
		echo '<input type="submit" value="' . $strendeditmenu . '" />';
		echo '<input type="hidden" value="0" name="topic" />';
		echo '<input type="hidden" value="' . $course->id . '" name="id" />';
		echo '</form>';
		print_container_end();

		print_container_start();

		$menuaction = optional_param('menuaction', 'config', PARAM_ALPHA);
		
		$opciones = array('config', 'tree', 'jstemplate', 'csstemplate', 'htmltemplate');
	
		if (!in_array($menuaction, $opciones)) {
			$menuaction = 'config';
		}
	
		$pestanas = array();
	
		$pestanas[] = new tabobject("tab_configmenu_config", $CFG->wwwroot.'/course/view.php?id='.$course->id . '&topic=-2&menuaction=config',
		'<font style="white-space:nowrap">' . get_string('config_editmenu', 'format_menutopic') . "</font>", get_string('config_editmenu', 'format_menutopic'));
		$pestanas[] = new tabobject("tab_configmenu_tree", $CFG->wwwroot.'/course/view.php?id='.$course->id . '&topic=-2&menuaction=tree',
		'<font style="white-space:nowrap">' . get_string('tree_editmenu', 'format_menutopic') . "</font>", get_string('tree_editmenu', 'format_menutopic'));
		$pestanas[] = new tabobject("tab_configmenu_jstemplate", $CFG->wwwroot.'/course/view.php?id='.$course->id . '&topic=-2&menuaction=jstemplate',
		'<font style="white-space:nowrap">' . get_string('jstemplate_editmenu', 'format_menutopic') . "</font>", get_string('jstemplate_editmenu', 'format_menutopic'));
		$pestanas[] = new tabobject("tab_configmenu_csstemplate", $CFG->wwwroot.'/course/view.php?id='.$course->id . '&topic=-2&menuaction=csstemplate',
		'<font style="white-space:nowrap">' . get_string('csstemplate_editmenu', 'format_menutopic') . "</font>", get_string('csstemplate_editmenu', 'format_menutopic'));
		$pestanas[] = new tabobject("tab_configmenu_htmltemplate", $CFG->wwwroot.'/course/view.php?id='.$course->id . '&topic=-2&menuaction=htmltemplate',
		'<font style="white-space:nowrap">' . get_string('htmltemplate_editmenu', 'format_menutopic') . "</font>", get_string('htmltemplate_editmenu', 'format_menutopic'));
	
	
		if (count($pestanas) > 0) {
			print_tabs(array($pestanas), "tab_configmenu_" . $menuaction);
		}
		
		include $CFG->dirroot . '/course/format/menutopic/form_' . $menuaction . '.php';
		print_container_end();
		echo '</td>';
	
	}
    echo '</tr></table>';
    
?>