<?php
include_once $CFG->libdir . '/pear/HTML/AJAX/JSON.php';

class format_menutopic_menu {
	
	public $treecode = '';
	private $config;
	
	// Object construct
	public function __construct($config = null) {
		if (!empty($config) && is_object($config)) {
			$this->_config	= $config;
		}
		else {
			$this->_config = new object();
			$this->_config->jsdefault = true;
			$this->_config->cssdefault = true;
			$this->_config->usehtml = false;
			$this->_config->menuposition = 'middle';
			$this->_config->linkinparent = false;			
		}
	}
	
	public function json_code_horizontal_menu () {
		if (empty($this->treecode)){
			return '';
		}
		
		$json = json_decode($this->treecode);
		$codetree = '';

		if (isset($json->topics) && is_array($json->topics)){
			foreach ($json->topics as $one_topic) {
				$codetree .= $this->json_item_menu ($one_topic) . ',';
			}
			$codetree = rtrim($codetree, ',');
		}

		return $codetree;
		
	}
	
	private function json_item_menu ($node) {
		$url = '';
		if (empty($node->url)) {
			if (!empty($node->topicnumber) || $node->topicnumber === "0") {
				global $course, $CFG;
				$url = $CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=' . $node->topicnumber;
			}
		}
		else {
			$url = $node->url;
		}
		
		if (isset($node->subtopics) && is_array($node->subtopics) && count($node->subtopics) > 0) {
			$id = rand();
			$submenu = '';
			foreach ($node->subtopics as $one_topic) {
				$submenu .= $this->json_item_menu ($one_topic) . ',';
			}
			
			$submenu = rtrim($submenu, ',');

			// If parent will linking with the url
			if (isset($this->config->linkinparent) && $this->config->linkinparent) {
				$item = '{ "text": "%s", "url": "%s", "submenu": {"id": "%s", "itemdata": [%s]}}';
				$res = sprintf($item, $node->name, $url, $id, $submenu);
			}
			else {
				$item = '{ "text": "%s", "submenu": {"id": "%s", "itemdata": [%s]}}';
				$res = sprintf($item, $node->name, $id, $submenu);
			}
		}
		else {
			
			$item = '{ "text": "%s", "url": "%s", "target": "%s"}';
			$res = sprintf($item, $node->name, $url, $node->target);
		}
		
		return $res;
	}

	public function list_code_horizontal_menu () {
		if (empty($this->treecode)){
			return '';
		}
		
		$json = json_decode($this->treecode);
		$codetree = '<ul>';

		if (isset($json->topics) && is_array($json->topics)){
			foreach ($json->topics as $one_topic) {
				$codetree .= $this->list_item_menu ($one_topic);
			}
		}

		return $codetree . '</ul>';
		
	}
	
	private function list_item_menu ($node) {
		$url = '';
		if (empty($node->url)) {
			if (!empty($node->topicnumber) || $node->topicnumber === "0") {
				global $course, $CFG;
				$url = $CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=' . $node->topicnumber;
			}
		}
		else {
			$url = $node->url;
		}
		
		if (isset($node->subtopics) && is_array($node->subtopics) && count($node->subtopics) > 0) {
			$id = rand();
			$submenu = '';
			foreach ($node->subtopics as $one_topic) {
				$submenu .= $this->list_item_menu ($one_topic);
			}
			
			// If parent will linking with the url
			if (isset($this->config->linkinparent) && $this->config->linkinparent) {
				$item = '<li class="yuimenuitem">
							<a class="yuimenuitemlabel" href="%s">%s</a>
							<div id="%s" class="yuimenu">
								<div class="bd">                                        
									<ul>
										%s
									</ul>
								</div>
							</div>
						 </li>';
				$res = sprintf($item, $url, $node->name, $id, $submenu);
			}
			else {
				$item = '<li class="yuimenuitem">
							%s
							<div id="%s" class="yuimenu">
								<div class="bd">                                        
									<ul>
										%s
									</ul>
								</div>
							</div>
						 </li>';
//				$item = '{ "text": "%s", "submenu": {"id": "%s", "itemdata": [%s]}}';
				$res = sprintf($item, $node->name, $id, $submenu);
			}
		}
		else {
			$item = '<li class="yuimenuitem">
						<a class="yuimenuitemlabel" href="%s" target="%s">%s</a>
					 </li>';
//			$item = '{ "text": "%s", "url": "%s", "target": "%s"}';
			$res = sprintf($item, $url, $node->target, $node->name);
		}
		
		return $res;
	}

	public function js_menu () {
		$print_for_menu = '';
		
		$print_for_menu .= '<div id="id_contenedor_menu" class="yui-skin-sam"></div>';
		$print_for_menu .= '<script language="javascript" type="text/javascript">';
		$print_for_menu .= ' var tree_menu_var = [';

		$print_for_menu .= $this->json_code_horizontal_menu ();
		$print_for_menu .= '];';

		if ($this->config->jsdefault) {
			if ($this->config->menuposition == 'left' || $this->config->menuposition == 'right') {
				$print_for_menu .= ' var menu_ppal_topics = new YAHOO.widget.Menu("id_contenedor_menu", { position: "static", hidedelay: 750, lazyload: true });';
			}
			else {
				$print_for_menu .= ' var menu_ppal_topics = new YAHOO.widget.MenuBar("id_contenedor_menu", { autosubmenudisplay: true, hidedelay: 750, lazyload: true });';
			}
	
			$print_for_menu .= ' menu_ppal_topics.addItems(tree_menu_var);';
	
			$print_for_menu .= ' menu_ppal_topics.subscribe("beforeShow", onSubmenuBeforeShow);
									menu_ppal_topics.subscribe("show", onSubmenuShow);';

			$print_for_menu .= ' menu_ppal_topics.render();';

			if ($this->config->menuposition == 'left' || $this->config->menuposition == 'right') {
				$print_for_menu .= ' menu_ppal_topics.show();';
			}
		}

		$print_for_menu .= ' </script>';

		return $print_for_menu;
	}
	
	public function html_menu () {
		global $CFG, $course;

		$htmlcode = '';
		$nocache = true;

		if ((!isset($this->config->wwwroot) || $this->config->wwwroot != $CFG->wwwroot) ||
				(isset($this->config->courseid) && $this->config->courseid != $course->id)) {
			$nocache = true;
		}

		if (!$nocache && file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME)) {
			$htmlcode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME);
		}
		else if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME)) {
			$htmlcode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME);
			
			if (empty($this->treecode)){
				return $htmlcode;
			}
			
			$json = json_decode($this->treecode);

			if (isset($json->topics) && is_array($json->topics)){
				foreach ($json->topics as $one_topic) {
					$htmlcode = $this->html_replace_tag ($htmlcode, $one_topic);
				}
			}
			
			//HTML to cache
			@file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_HTML_CACHE_NAME, $htmlcode);
		}
		
		return $htmlcode;
	}

	public function list_menu () {
		$print_for_menu = '';
		
		$print_for_menu .= '<div id="id_contenedor_menu" class="yui-skin-sam"><div class="bd">';

		$print_for_menu .= $this->list_code_horizontal_menu ();
		$print_for_menu .= '</div></div>';

		return $print_for_menu;
	}

	private function html_replace_tag ($htmlcode, $node) {
		$url = '';
		$relative_url = '';
		if (empty($node->url)) {
			if (!empty($node->topicnumber) || $node->topicnumber === '0') {
				global $course, $CFG;
				$url = $CFG->wwwroot . '/course/view.php?id=' . $course->id . '&topic=' . $node->topicnumber;
				$relative_url = 'course/view.php?id=' . $course->id . '&topic=' . $node->topicnumber;
			}
		}
		else {
			$url = $node->url;
			$relative_url = $url;
		}

		$node_quote_name = preg_quote($node->name, '/');

		//Replace only the URL in special pattern: [[name:url]]
		$pattern = '/(\[\[)(([<][^>]*>)*)' . $node_quote_name . ':url([^\]]*)\]\]/i';
		$htmlcode = preg_replace($pattern, $relative_url, $htmlcode);

		//Replace the link in pattern: [[name]]
		$item = '<a href="%s" target="%s" >%s</a>';
		$change = sprintf($item, $url, $node->target, $node->name);
		$pattern = '/(\[\[)(([<][^>]*>)*)' . $node_quote_name . '([^\]]*)\]\]/i';

		$htmlcode = preg_replace($pattern, $change, $htmlcode);
		
		if (isset($node->subtopics) && is_array($node->subtopics) && count($node->subtopics) > 0) {
			foreach ($node->subtopics as $one_topic) {
				$htmlcode = $this->html_replace_tag ($htmlcode, $one_topic);
			}
		}

		
		return $htmlcode;
	}

	public function script_menu($config) {
		$this->config = $config;
		$print_for_menu = '';
		
		if ($this->config->usehtml) {
			$print_for_menu = $this->html_menu();
		}
		else {
			if ($this->config->jsdefault) {
				$print_for_menu = $this->js_menu();
			}
			else {
				$print_for_menu = $this->list_menu();
			}
		}
		
		return $print_for_menu;
	}
	
	public function fix_urls ($config) {
		global $CFG, $course;
		$this->config = $config;

		$htmlcode = null;
		$csscode = null;
		$jscode = null;

		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME)) {
			$htmlcode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME);
		}
		
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_JS_NAME)) {
			$jscode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_JS_NAME);
		}
		
		if (file_exists(PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME)) {
			$csscode = file_get_contents(PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME);
		}
		
		$new_htmlcode = $htmlcode;
		$new_csscode = $csscode;
		$new_jscode = $jscode;

		if (isset($this->config->courseid) && $this->config->courseid != $course->id) {
			//Replace the course URL because the course was create in other space, this was migrated
			
			if (!empty($new_htmlcode)) {
				$new_htmlcode = str_replace('/file.php/' . $this->config->courseid . '/', '/file.php/' . $course->id . '/', $new_htmlcode);
				$new_htmlcode = str_replace('/file.php?file=/' . $this->config->courseid . '/', '/file.php?file=/' . $course->id . '/', $new_htmlcode);
			}

			if (!empty($new_csscode)) {
				$new_csscode = str_replace('/file.php/' . $this->config->courseid . '/', '/file.php/' . $course->id . '/', $new_csscode);
				$new_csscode = str_replace('/file.php?file=/' . $this->config->courseid . '/', '/file.php?file=/' . $course->id . '/', $new_csscode);
			}

			if (!empty($new_jscode)) {
				$new_jscode = str_replace('/file.php/' . $this->config->courseid . '/', '/file.php/' . $course->id . '/', $new_jscode);
				$new_jscode = str_replace('/file.php?file=/' . $this->config->courseid . '/', '/file.php?file=/' . $course->id . '/', $new_jscode);
			}
		}

		if (isset($this->config->wwwroot) && $this->config->wwwroot != $CFG->wwwroot) {
			//Replace the site URL because the course was migrated to other platform
			
			if (!empty($new_htmlcode)) {
				$new_htmlcode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_htmlcode);
				$new_htmlcode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_htmlcode);
			}

			if (!empty($new_csscode)) {
				$new_csscode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_csscode);
				$new_csscode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_csscode);
			}

			if (!empty($new_jscode)) {
				$new_jscode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_jscode);
				$new_jscode = str_replace($this->config->wwwroot, $CFG->wwwroot, $new_jscode);
			}
		}

		//If some code change, I put new code in the code file

		if ($new_htmlcode != $htmlcode) {
			@file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_HTML_NAME, $new_htmlcode);
		}

		if ($new_csscode != $csscode) {
			@file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_CSS_NAME, $new_csscode);
		}

		if ($new_jscode != $jscode) {
			@file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_JS_NAME, $new_jscode);
		}

		//If the config don't contain the variables: wwwroot and courseid, the config object is reload in the config file
		if ((!isset($this->config->wwwroot) || $this->config->wwwroot != $CFG->wwwroot) ||
				(!isset($this->config->courseid) || $this->config->courseid != $course->id)) {
			
			$this->config->wwwroot = $CFG->wwwroot;
			$this->config->courseid = $course->id;
			$values = serialize($this->config);
			@file_put_contents (PATH_FORMAT_SAVE . '/' . FILE_CONFIG_NAME, $values);
		}
	}
}
?>