<?php

function format_personalsection_replace_resources ($summary, $config, $course, $section, &$mods, $modnamesused) {
	
	global $CFG, $USER;

    static $initialised;

    static $groupbuttons;
    static $groupbuttonslink;
    static $isediting;
    static $strunreadpostsone;
    static $usetracking;
    static $groupings;


    if (!isset($initialised)) {
        $groupbuttons     = ($course->groupmode or (!$course->groupmodeforce));
        $groupbuttonslink = (!$course->groupmodeforce);
        $isediting        = isediting($course->id);
        include_once($CFG->dirroot.'/mod/forum/lib.php');
        if ($usetracking = forum_tp_can_track_forums()) {
            $strunreadpostsone = get_string('unreadpostsone', 'forum');
        }
        $initialised = true;
    }

    $labelformatoptions = new object();
    $labelformatoptions->noclean = true;

/// Casting $course->modinfo to string prevents one notice when the field is null
    $modinfo = get_fast_modinfo($course);


	$html_resource = '';

    if (!empty($section->sequence)) {
        $sectionmods = explode(",", $section->sequence);
		
		$obj_replace = new format_personalsection_replace_regularexpression();

		foreach ($sectionmods as $modnumber) {
            if (empty($mods[$modnumber])) {
                continue;
            }

            $mod = $mods[$modnumber];

            if ($mod->modname == "label") {
                continue;
            }

            if (isset($modinfo->cms[$modnumber])) {
                if (!$modinfo->cms[$modnumber]->uservisible) {
					$instancename = format_string($modinfo->cms[$modnumber]->name, true,  $course->id);
					//Replace the link in pattern: [[resource name]]
					$summary = preg_replace("/(\[\[)(([<][^>]*>)*)((" . preg_quote($instancename, '/') . ")(:?))([^\]]*)\]\]/i", '', $summary);
                    continue;
                }
            } else {
                if (!file_exists("$CFG->dirroot/mod/$mod->modname/lib.php")) {
                    // module not installed
                    continue;
                }
                if (!coursemodule_visible_for_user($mod)) {
                    // full visibility check
                    continue;
                }
            }

            $html_resource =  '<span class="context_activity activity '.$mod->modname.'">';

            $extra = '';
            if (!empty($modinfo->cms[$modnumber]->extra)) {
                $extra = $modinfo->cms[$modnumber]->extra;
            }

			$instancename = format_string($modinfo->cms[$modnumber]->name, true,  $course->id);

			if (!empty($modinfo->cms[$modnumber]->icon)) {
				$icon = "$CFG->pixpath/".$modinfo->cms[$modnumber]->icon;
			} else {
				$icon = "$CFG->modpixpath/$mod->modname/icon.gif";
			}

			//Accessibility: for files get description via icon.
			$altname = '';
			if ('resource'==$mod->modname) {
				if (!empty($modinfo->cms[$modnumber]->icon)) {
					$possaltname = $modinfo->cms[$modnumber]->icon;

					$mimetype = mimeinfo_from_icon('type', $possaltname);
					$altname = get_mimetype_description($mimetype);
				} else {
					$altname = $mod->modfullname;
				}
			} else {
				$altname = $mod->modfullname;
			}
			// Avoid unnecessary duplication.
			if (false!==stripos($instancename, $altname)) {
				$altname = '';
			}
			// File type after name, for alphabetic lists (screen reader).
			if ($altname) {
				$altname = get_accesshide(' '.$altname);
			}

			$linkcss = $mod->visible ? "" : " class=\"dimmed\" ";
			
			$html_resource .= '<a '.$linkcss.' '.$extra.        // Title unnecessary!
				 ' href="'.$CFG->wwwroot.'/mod/'.$mod->modname.'/view.php?id='.$mod->id.'">';
			if ($config->icons_templatetopic) {
				$html_resource .= '<img src="'.$icon.'" class="activityicon" alt="" />';
			}
			$html_resource .= ' <span>' . $obj_replace->_tag_string . $altname.'</span></a>';

			if (!empty($CFG->enablegroupings) && !empty($mod->groupingid) && has_capability('moodle/course:managegroups', get_context_instance(CONTEXT_COURSE, $course->id))) {
				if (!isset($groupings)) {
					$groupings = groups_get_all_groupings($course->id);
				}
				$html_resource .= " <span class=\"groupinglabel\">(".format_string($groupings[$mod->groupingid]->name).')</span>';
			}

            if ($usetracking && $mod->modname == 'forum') {
                if ($unread = forum_tp_count_forum_unread_posts($mod, $course)) {
                    $html_resource .= '<span class="unread"> <a href="'.$CFG->wwwroot.'/mod/forum/view.php?id='.$mod->id.'">';
                    if ($unread == 1) {
                        $html_resource .= $strunreadpostsone;
                    } else {
                        $html_resource .= get_string('unreadpostsnumber', 'forum', $unread);
                    }
                    $html_resource .= '</a></span>';
                }
            }

            $html_resource .= "</span>\n";
			
			//Replace the link in pattern: [[resource name]]
			$obj_replace->_string_replace = $html_resource;
			$obj_replace->_string_search = $instancename;
			
			$new_summary = preg_replace_callback("/(\[\[)(([<][^>]*>)*)((" . preg_quote($obj_replace->_string_search, '/') . ")(:?))([^\]]*)\]\]/i", array($obj_replace, "format_personalsection_replace_tag_in_expresion"), $summary); 

			if ($new_summary != $summary) {
				unset($mods[$modnumber]);
			}

			$summary = $new_summary;
        }

    }

	return $summary;
	
}

class format_personalsection_replace_regularexpression {
	public $_string_search;
	public $_string_replace;
	
	public $_tag_string = '{label_tag_replace}';

	public function format_personalsection_replace_tag_in_expresion ($match) {

		$term = $match[0];
		$term = str_replace("[[", '', $term);
		$term = str_replace("]]", '', $term);

		$text = strip_tags($term);
		if (strpos($text, ':') > -1) {
			
			$pattern = '/([^:])+:/i';
			$text = preg_replace($pattern, '', $text);
			
			//Change text for alternative text
			$new_replace = str_replace($this->_tag_string, $text, $this->_string_replace);
			
			//posible html tags position
			$pattern = '/([>][^<]*:[^<]*[<])+/i';
			$term = preg_replace($pattern, '><:><', $term);

			$pattern = '/([>][^<]*:[^<]*$)+/i';
			$term = preg_replace($pattern, '><:>', $term);

			$pattern = '/(^[^<]*:[^<]*[<])+/i';
			$term = preg_replace($pattern, '<:><', $term);

			$pattern = '/(^[^<]*:[^<]*$)/i';
			$term = preg_replace($pattern, '<:>', $term);

			$pattern = '/([>][^<^:]*[<])+/i';
			$term = preg_replace($pattern, '><', $term);

			$term = str_replace('<:>', $new_replace, $term);
		}
		else {
			//Change tag for resource or mod name
			$new_replace = str_replace($this->_tag_string, $this->_string_search, $this->_string_replace);
			$term = str_replace($this->_string_search, $new_replace, $term);
		}
		return $term;
	}
}

?>