<?php

class flash_comments_actions {

    static function insert ($instance) {
        global $COURSE, $USER, $CFG;

        $text_message = optional_param('text_message', '', PARAM_TEXT);
        $text_user_name = optional_param('text_user_name', '', PARAM_TEXT);
        $text_user_email = optional_param('text_user_email', '', PARAM_TEXT);
        $text_captcha = optional_param('text_captcha', '', PARAM_TEXT);

        $allow_guest = isset($instance->config->allow_guest) ? $instance->config->allow_guest : false;
		$capability = has_capability('block/flash_comments:postmessage', get_context_instance(CONTEXT_COURSE, $COURSE->id));

        if ((isset($instance->config->active_captcha) && $instance->config->active_captcha == true) && 
                (!$capability && $allow_guest) &&
                !empty($CFG->recaptchapublickey) && !empty($CFG->recaptchaprivatekey)) {
            require_once "HTML/QuickForm/input.php";
            require_once $CFG->libdir . '/form/recaptcha.php';
            $captcha_form = new MoodleQuickForm_recaptcha('text_captcha', get_string('captcha', 'block_flash_comments'));

            $challenge_field = optional_param('recaptcha_challenge_field', '', PARAM_TEXT);
            $response_field = optional_param('recaptcha_response_field', '', PARAM_TEXT);
            
            if (!empty($challenge_field)) {
                if (true !== ($result = $captcha_form->verify($challenge_field, $response_field))) {
                    if ($result == 'incorrect-captcha-sol') {
                        die(get_string('msg_error_captcha', 'block_flash_comments'));
                    }
                    else {
                        die($result);
                    }
                }
            } else {
                die(get_string('missingrecaptchachallengefield'));
            }
        }

        $comment = new stdClass();
        $comment->resourceid = $COURSE->id;
        $comment->comment    = $text_message;
        $comment->userid     = $USER->id;
        $comment->username   = $text_user_name;
        $comment->useremail  = $text_user_email;
        $comment->ip         = getremoteaddr();
        $comment->time       = time();
        
        $comment->id = insert_record('flash_comments', $comment, true);

        $link_to_perfil      = !($USER->username == 'guest');
        $comment->user       = new stdClass();
        $comment->user->picture = print_user_picture($USER, $COURSE->id, $USER->picture, false, true, $link_to_perfil);
        $comment->user->date    = userdate($comment->time, get_string('strftimedatetime'));
        
        if ($USER->username !== 'guest') {
            $comment->username = fullname($USER);
            $comment->useremail  = $USER->email;
        }
        
        $comment->comment = format_text($comment->comment, FORMAT_MOODLE);
        
        //Se tiene que regresar como un arreglo para la compatibilidad con JSON
        return array('comment'=>$comment);
        
    }

    static function delete ($instance) {
        global $COURSE, $USER, $CFG;

        $commentid = optional_param('commentid', '', PARAM_INT);
        
        if (empty($commentid)) {
            die(get_string('msg_error_id_comment', 'block_flash_comments'));
        }

        $res = false;
		if(has_capability('block/flash_comments:managemessages', get_context_instance(CONTEXT_COURSE, $COURSE->id))) {
            if (delete_records('flash_comments', 'id', $commentid)) {
                $res = true;
            }
        }

        //Se tiene que regresar como un arreglo para la compatibilidad con JSON
        return array('response'=>$res);
        
    }
}


?>