<?php

/**
 * Comentarios rpidos en un curso, no se necesita ser usuario
 *
 * @author David Herney Bernal Garca davidherney@gmail.com
 * @author Programa Integracin de tecnologas a la docencia - Universidad de Antioquia
 * @version  $Id: block_flash_comments.php,v 1.0 2010-10-13 10:35:26 dhbernal Exp $
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @package UdeA
 */

class block_flash_comments extends block_base {
    function init() {
        $this->title = get_string('block_title', 'block_flash_comments');
        $this->version = 2010101302;
    }
    
    function has_config() {
      return false;
    }

    function instance_allow_config() {
        return true;
    }

    function get_content() {
        if ($this->content !== NULL) {
            return $this->content;
        }

        global $CFG, $USER, $COURSE;

        //VARIABLES DE CONFIGURACION
//		$diferencia = isset($CFG->block_contador_espera) ? $CFG->block_contador_espera : 14400;

        //La posibilidad de manejar los comentarios a nivel de contenido se deja para la segunda versin
        //$context = get_context_instance(CONTEXT_MODULE, $cm->id)
        
        /*if (empty($this->instance->pinned)) {
            $context = get_context_instance(CONTEXT_BLOCK, $this->instance->id);
        } else {
            $context = get_context_instance(CONTEXT_SYSTEM); // pinned blocks do not have own context
        }*/

        $text = '';
        
        $message_to_see = isset($this->config->message_to_see) ? $this->config->message_to_see : 5;

        if (has_capability('block/flash_comments:viewmessages', get_context_instance(CONTEXT_COURSE, $COURSE->id))) {
            $text .= '
            <script>
            var _FLASH_MESSAGE_VIEW = true;
            var _FLASH_MESSAGE_LIMIT = ' . $message_to_see . ';
            </script>
            <a href="' . $CFG->wwwroot . '/blocks/flash_comments/view_history.php?id=' . $COURSE->id . '">' . get_string('view_all_messages', 'block_flash_comments') . '</a>
            <div class="flash_comments_short">
            <ul id="container_flash_messages" class="flash_comments_list">';

            $tpl_message = '<li><div class="flash_comment_user">%2$s %1$s <div class="flash_comment_time">%3$s</div></div><div class="flash_comment_message">%4$s</div></li>';
            $rs = get_recordset('flash_comments', 'resourceid', $COURSE->id, 'time DESC', '*', 0, $message_to_see);

            $text_comment = '';
            $user_guest = get_record('user', 'username', 'guest', '', '', '', '', 'id, picture');
            
            while ($rec = rs_fetch_next_record($rs)) {
                if ($rec->userid > 0 && $rec->userid !== $user_guest->id) {
                    $user_comment = get_record('user', 'id', $rec->userid, '', '', '', '', 'id, picture, firstname, lastname');
                    $link_to_perfil = true;
                }
                else {
                    $user_comment = $user_guest;
                    $user_comment->firstname = $rec->username;
                    $user_comment->lastname = '';
                    $link_to_perfil = false;
                }
                $user_picture = print_user_picture($user_comment, $COURSE->id, $user_comment->picture, false, true, $link_to_perfil);
                $text_comment = sprintf($tpl_message, 
                                            fullname($user_comment), 
                                            $user_picture, 
                                            userdate($rec->time, get_string('strftimedatetime')), 
                                            format_text($rec->comment, FORMAT_MOODLE)
                                        ) . $text_comment;
            }
            rs_close($rs);
             
            $text .= $text_comment . '
            </ul></div>';
        }

		$capability = has_capability('block/flash_comments:postmessage', get_context_instance(CONTEXT_COURSE, $COURSE->id));

        $allow_guest = isset($this->config->allow_guest) ? $this->config->allow_guest : false;
        $active_captcha = isset($this->config->active_captcha) && (!$capability || isguestuser())  ? $this->config->active_captcha : false;
		
		//Not confirm that user is the guest user because the user can that it's not logued
        if ($capability || $allow_guest) {
			/*if (!$capability || isguestuser()) {
				$active_captcha = true;
			}
			else {
				$active_captcha = false;
			}*/
            
			require_js(array('yui_yahoo', 'yui_event', 'yui_json', 'yui_dom', 'yui_connection', 'yui_container', 'yui_dragdrop', 'yui_element', 'yui_button', 'yui_animation', $CFG->wwwroot . "/blocks/flash_comments/lib.js.php"));

			$text .= '<script language="javascript" type="text/javascript">';
			//This line is need to make possible the YUI grafic effects
			$text .= 'document.body.className += " yui-skin-sam";';
			$text .= 'var MODAL_WINDOW_FLASH_COMMENTS = new YAHOO.widget.Panel("modal_window",';
			$text .= '			{ width:"240px", ';
			$text .= '			  fixedcenter:true, ';
			$text .= '			  close:false, ';
			$text .= '			  draggable:false, ';
			$text .= '			  zindex:4,';
			$text .= '			  modal:true,';
			$text .= '			  visible:false';
			$text .= '			} ';
			$text .= '		);';
			$text .= 'MODAL_WINDOW_FLASH_COMMENTS.setHeader("' . get_string('msg_loading', 'block_flash_comments') . '");';
			$text .= 'MODAL_WINDOW_FLASH_COMMENTS.setBody(\'<img src="' . $CFG->wwwroot . '/blocks/flash_comments/imgs/loading.gif" />\');';
			$text .= 'MODAL_WINDOW_FLASH_COMMENTS.render(document.body);';
			$text .= '</script>';

            
            $text .= '
            <form method="post" class="mform" id="frm_flash_comments">
            <label>' . get_string('message', 'block_flash_comments') . '</label><br />
            <textarea name="text_message" id="text_message" class="input_text" ></textarea><br />';
            
            if (!$capability) {
                $text .= '<div id="block_flash_comments_extraform"><div><label>' . get_string('user_name', 'block_flash_comments') . '</label><br />
                <input type="text" name="text_user_name" id="text_user_name" class="input_text" /></div>
                <div><label>' . get_string('user_email', 'block_flash_comments') . '</label><br />
                <input type="text" name="text_user_email" id="text_user_email" class="input_text" /></div>';

                //Si se activa el captcha en el bloque para seguridad de los mensajes
                if ($active_captcha && !empty($CFG->recaptchapublickey) && !empty($CFG->recaptchaprivatekey)) {
                    require_once "HTML/QuickForm/input.php";
                    require_once $CFG->libdir . '/form/recaptcha.php';
                    $captcha_form = new MoodleQuickForm_recaptcha('text_captcha', get_string('captcha', 'block_flash_comments'));

                    $text .= '<div><label>' . get_string('captcha', 'block_flash_comments') . '</label>' . $captcha_form->toHTML();
                    $text .= '
                    <script type="text/javascript">
                        var RecaptchaOptions = {
                            theme : \'custom\',
                            custom_theme_widget : \'recaptcha_widget\',
                            width: \'100%\'
                        };
                    </script></div>';

                    $text .= '<script type="text/javascript">
                        var attributes = {
                            height: { to: 250 }
                        };
                        var block_flash_comments_anim = new YAHOO.util.Anim("block_flash_comments_extraform", attributes);
                        YAHOO.util.Event.on("text_message", "focus", function() { 
                            block_flash_comments_anim.animate();
                        });
                    </script>';
                }

                $text .= "</div>"; //Close the block_flash_comments_extraform div
            }
            $text .= '
            <input type="button" value="' . get_string('send', 'block_flash_comments') . '" onclick="send_flash_comment()" />
            <input type="hidden" value="' . $COURSE->id . '" name="id" />
            <input type="hidden" value="' . $this->instance->id . '" name="instance" />
            </form>';
        }
        
        $this->content = new stdClass;
        $this->content->text = $text;
        $this->content->footer = '';
    
        return $this->content;
    }

    //Por ahora no se respaldan los comentarios, se consideran propios de la instancia del curso
    /*
    function instance_backup($bf, $preferences) {
        global $CFG;
        
        $status = true;
        
        $rs = get_recordset('flash_comments', 'resourceid', $COURSE->id, null, '*');

        while ($rec = rs_fetch_next_record($rs)) {
            fwrite ($bf,start_tag("COMMENT",5,true));
            
            //Print forum data
            fwrite ($bf,full_tag("ID",6,false,$rec->id));
            fwrite ($bf,full_tag("RESOURCETYPE",6,false,$rec->resourcetype));
            fwrite ($bf,full_tag("RESOURCEID",6,false,$rec->resourceid));
            fwrite ($bf,full_tag("COMMENT",6,false,$rec->comment));
            fwrite ($bf,full_tag("USERID",6,false,$rec->userid));
            fwrite ($bf,full_tag("USERNAME",6,false,$rec->username));
            fwrite ($bf,full_tag("USEREMAIL",6,false,$rec->useremail));
            fwrite ($bf,full_tag("IP",6,false,$rec->ip));
            fwrite ($bf,full_tag("TIME",6,false,$rec->time));
            
            //End mod
            $status =fwrite ($bf,end_tag("COMMENT",5,true));
        }

        return $status;
    }*/
}

?>