<?php

    require_once('../../config.php');

?>

function $ (id) {
	return YAHOO.util.Dom.get(id);
}

function rtrim(text) {
    text += "";
    for (var i = text.length -1; (i >= 0) && ((text.charAt(i) == ' ')); i--)
        ;
    return text.substring(0, i+1);
}

function ltrim(text) {
    text += "";
    for (var i = 0; (i < text.length) && ((text.charAt(i) == ' ')); i++)
        ;
    if (i == text.length) {
        return "";
    }
    return text.substring(i);
}

function trim(text) {
    return ltrim(rtrim(text));
}


var MESSAGE_TYPES = {"ALARM": {"icon": YAHOO.widget.SimpleDialog.ICON_ALARM, "title": "<?php print_string('title_alarm', 'block_flash_comments');?>"}, 
						"HELP": {"icon": YAHOO.widget.SimpleDialog.ICON_HELP, "title": "<?php print_string('title_help', 'block_flash_comments');?>"},
						"INFO": {"icon": YAHOO.widget.SimpleDialog.ICON_INFO, "title": "<?php print_string('title_info', 'block_flash_comments');?>"},
						"ERROR": {"icon": YAHOO.widget.SimpleDialog.ICON_WARN, "title": "<?php print_string('title_error', 'block_flash_comments');?>"},
						"BANNED": {"icon": YAHOO.widget.SimpleDialog.ICON_BLOCK, "title": "<?php print_string('title_banned', 'block_flash_comments');?>"},
						"TIP": {"icon": YAHOO.widget.SimpleDialog.ICON_TIP, "title": "<?php print_string('title_tip', 'block_flash_comments');?>"}
						}

var _MESSAGE_QUEUE = new Array();
var _MESSAGE_POINTER = 0;

function message(text, type) {
	
	if (!type) {
		type = MESSAGE_TYPES.INFO;
	}
	
	if (_MESSAGE_POINTER >= _MESSAGE_QUEUE.length) {
		show_message(text, type);
	}
	_MESSAGE_QUEUE[_MESSAGE_QUEUE.length] = [text, type];

}

function show_message (text, type) {

	var handleOK = function() {
		this.hide();
		_MESSAGE_POINTER++;
		if (_MESSAGE_POINTER < _MESSAGE_QUEUE.length) {
			show_message(_MESSAGE_QUEUE[_MESSAGE_POINTER][0], _MESSAGE_QUEUE[_MESSAGE_POINTER][1]);
		}
	};

	var alert_window = new YAHOO.widget.SimpleDialog("alert_message", 
			 { width: '400px',
			   fixedcenter: true,
			   visible: true,
			   draggable: false,
			   close: false,
			   text: text,
			   icon: type.icon,
			   constraintoviewport: true,
			   modal: true,
			   zindex: 5,
			   buttons: [ { text:"<?php print_string('btn_ok', 'block_flash_comments');?>", handler:handleOK, isDefault:true } ]
			 } );

	alert_window.setHeader(type.title);
	alert_window.render(document.body);
	alert_window.show();
}

function load_messages (id) {
	MODAL_WINDOW_FLASH_COMMENTS.show();
	var url = "<?php echo $CFG->wwwroot; ?>/blocks/flash_comments/view_messages.php";
	
	YAHOO.util.Connect.asyncRequest("GET", url,
			{
				success: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					try {
						var obj = $('middle-column');
						
						if (!obj) {
							obj = $('pnl_content_ocw_category');
						}
						
						if (obj) {
							obj.innerHTML = o.responseText;
							document.location.href = '#';
						}
					}
					catch (e) {
						message(o.responseText, MESSAGE_TYPES.ERROR);
						return false;
					}
				},

				failure: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					alert("<?php print_string('msg_error_sending', 'block_flash_comments');?>");
				}
	});
	
	return;
}


function send_flash_comment () {
	MODAL_WINDOW_FLASH_COMMENTS.show();
	var url = "<?php echo $CFG->wwwroot; ?>/blocks/flash_comments/manage_messages.php?action=insert";

	var form = $('frm_flash_comments');
	
	YAHOO.util.Connect.setForm(form);
	
	YAHOO.util.Connect.asyncRequest("POST", url,
			{
				success: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					var json_object;
                    if (typeof(Recaptcha) != 'undefined') {
                        Recaptcha.reload();
                    }
					try {
						if (o.responseText == '') {
							message('<?php print_string('msg_error_response', 'block_flash_comments');?>');
							return;
						}
						json_object = YAHOO.lang.JSON.parse(o.responseText);
					}
					catch (e) {
						message(o.responseText, MESSAGE_TYPES.ERROR);
						return false;
					}
					
					
					if (json_object.errors && json_object.errors.length > 0) {
						var text = '';
						for (var i = 0; i < json_object.errors.length; i++) {
							text += '<li>' + json_object.errors[i] + '</li>';
						}
						message('<ul>' + text + '</ul>', MESSAGE_TYPES.ERROR);
						return false;
					}
					
                    if (json_object.comment) {
                        return insert_flash_comment (json_object.comment);
                    }
                    else {
						message(o.responseText, MESSAGE_TYPES.ERROR);
                        return false;
                    }

				},

				failure: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					alert("<?php print_string('msg_error_sending', 'block_flash_comments');?>");
				}
	});
	
	return;
}


function insert_flash_comment (comment) {
    var control;
    //Clean the controls
    if (control = $('text_message')) {
        control.value = '';
    }
    if (control = $('text_user_name')) {
        control.value = '';
    }
    if (control = $('text_user_email')) {
        control.value = '';
    }

    if (!_FLASH_MESSAGE_VIEW) {
        return;
    }
    
    var messages_container = $('container_flash_messages');
    
    var one_message = document.createElement("li");
    var user_info = document.createElement("div");
    user_info.className = "flash_comment_user";
    user_info.appendChild(document.createTextNode(comment.username));
    
    user_info.innerHTML = comment.user.picture + user_info.innerHTML;
    
    var message_time = document.createElement("div");
    message_time.className = "flash_comment_time";
    message_time.appendChild(document.createTextNode(comment.user.date));
    user_info.appendChild(message_time);

    one_message.appendChild(user_info);
    
    var text = document.createElement("div");
    text.className = "flash_comment_message";
    text.innerHTML = comment.comment;//appendChild(document.createTextNode());
    one_message.appendChild(text);
    
    messages_container.appendChild(one_message);
    
    //Remove nodes until only the desired
	var nodes = messages_container.childNodes;

    //Add 1 to nodes length by the textnode in UL
	if (nodes && (nodes.length + 1) > _FLASH_MESSAGE_LIMIT) {
        messages_container.removeChild(nodes[0]);
    }
    /*
    var limit = _FLASH_MESSAGE_LIMIT ? _FLASH_MESSAGE_LIMIT : 5;
	if (nodes && nodes.length > _FLASH_MESSAGE_LIMIT) {
		while (nodes.length > _FLASH_MESSAGE_LIMIT) {
			messages_container.removeChild(nodes[0]);
		}
	}*/

}


function delete_instance_flash_comment (commentid, courseid, link) {
	MODAL_WINDOW_FLASH_COMMENTS.show();
	var url = "<?php echo $CFG->wwwroot; ?>/blocks/flash_comments/manage_messages.php?action=delete&commentid=" + commentid + "&id=" + courseid;

	YAHOO.util.Connect.asyncRequest("GET", url,
			{
				success: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					var json_object;

                    
					try {
						if (o.responseText == '') {
							message('<?php print_string('msg_error_response', 'block_flash_comments');?>');
							return;
						}
						json_object = YAHOO.lang.JSON.parse(o.responseText);
					}
					catch (e) {
						message(o.responseText, MESSAGE_TYPES.ERROR);
						return false;
					}
					
					
					if (json_object.errors && json_object.errors.length > 0) {
						var text = '';
						for (var i = 0; i < json_object.errors.length; i++) {
							text += '<li>' + json_object.errors[i] + '</li>';
						}
						message('<ul>' + text + '</ul>', MESSAGE_TYPES.ERROR);
						return false;
					}
					
                    
                    if (json_object.response == true) {
                    
                        var li = link.parentNode;
                        while (li && li.nodeName.toUpperCase() != "LI") {
                            li = li.parentNode;
                        }
                        
                        li.innerHTML = '';
                        li.style.display = 'none';

                        
                        return true;
                    }
                    else {
						message("<?php print_string('msg_error_deleting', 'block_flash_comments');?>", MESSAGE_TYPES.ERROR);
                        return false;
                    }

				},

				failure: function (o) {
					MODAL_WINDOW_FLASH_COMMENTS.hide();
					alert("<?php print_string('msg_error_sending', 'block_flash_comments');?>");
				}
	});
	
	return;
}