<?php

    require_once('../../config.php');

//Not cache because is an AJAX Page
    header("Expires: Tue, 01 Jul 2001 06:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    $action = optional_param('action', '', PARAM_TEXT);
	
	if (empty($action)) {
		die(get_string('msg_error_no_action', 'block_flash_comments'));
	}

    $id = optional_param('id', 0, PARAM_INT); // resource id

	if (empty($id)) {
		die(get_string('msg_error_id_parameter', 'block_flash_comments'));
	}

    $allow_guest = false;
    $block_instance = null;
    if ($action == 'insert') {
        $instanceid = optional_param('instance', 0, PARAM_INT); // block instance id
        if (empty($instanceid)) {
            die(get_string('msg_error_instance_parameter', 'block_flash_comments'));
        }

        $instance = get_record('block_instance', 'id', $instanceid);

        $block_instance = block_instance('flash_comments', $instance);

        $allow_guest = isset($block_instance->config->allow_guest) ? $block_instance->config->allow_guest : false;
    }

    //Now, it is only to courses
    //ToDo: Extender para que los comentarios puedan ir en recursos
    $COURSE = get_record('course', 'id', $id);

	if (!$COURSE) {
		die(get_string('msg_error_course_does_not_exist', 'block_flash_comments'));
	}

/**Manejo de la seguridad*/

    if (empty($USER) || empty($USER->id)) {
        $USER = get_record('user', 'username', 'guest');
    }

    if ($action == 'insert') {
        if (!has_capability('block/flash_comments:postmessage', get_context_instance(CONTEXT_COURSE, $COURSE->id)) && !$allow_guest) {
            die(get_string('msg_error_no_capability', 'block_flash_comments'));
        }
    }

/**Fin Manejo de la seguridad*/

    require_once 'actions.php';

	$allowed_actions = array();
    
    //Se controlan las acciones dependiendo de los permisos de los usuarios
	if (has_capability('block/flash_comments:postmessage', get_context_instance(CONTEXT_COURSE, $COURSE->id)) || $allow_guest){
        $allowed_actions[] = 'insert';
    }
	if (has_capability('block/flash_comments:managemessages', get_context_instance(CONTEXT_COURSE, $COURSE->id))){
        $allowed_actions[] = 'delete';
    }
	
	if (!method_exists('flash_comments_actions', $action) || !in_array($action, $allowed_actions)) {
		die(get_string('msg_error_action_no_exist', 'block_flash_comments'));
	}
	
	//Ejecuta la funcion segun la accion solicitada
	$res = flash_comments_actions::$action($block_instance);
    
	include_once $CFG->libdir . '/pear/HTML/AJAX/JSON.php';
	$json = json_encode($res);
	echo $json;

?>