<?php
    include_once '../../config.php';

    if ($CFG->forcelogin) {
        require_login();
    }

    if (!$site = get_site()) {
        die('Site isn\'t defined!');
    }

    $id     = required_param('id', PARAM_INT);              // course id
    $COURSE = get_record('course', 'id', $id);

    if (!$COURSE) {
        error('Course ID was incorrect');
    }

    $strname = get_string('all_messages', 'block_flash_comments');
    $navlinks = array();
    $navlinks[] = array('name'=>$strname, 'link'=>'','type'=>'misc');
    
    $navigation = build_navigation($navlinks);

    print_header("$site->shortname", $strname, $navigation);

    if (has_capability('block/flash_comments:viewmessages', get_context_instance(CONTEXT_COURSE, $COURSE->id))) {

        require_js(array('yui_yahoo', 'yui_event', 'yui_json', 'yui_dom', 'yui_connection', 'yui_container', 'yui_dragdrop', 'yui_element', 'yui_button', 'yui_animation', $CFG->wwwroot . "/blocks/flash_comments/lib.js.php"));

        $text_comment = '<script language="javascript" type="text/javascript">';
        //This line is need to make possible the YUI grafic effects
        $text_comment .= 'document.body.className += " yui-skin-sam";';
        $text_comment .= 'var MODAL_WINDOW_FLASH_COMMENTS = new YAHOO.widget.Panel("modal_window",';
        $text_comment .= '			{ width:"240px", ';
        $text_comment .= '			  fixedcenter:true, ';
        $text_comment .= '			  close:false, ';
        $text_comment .= '			  draggable:false, ';
        $text_comment .= '			  zindex:4,';
        $text_comment .= '			  modal:true,';
        $text_comment .= '			  visible:false';
        $text_comment .= '			} ';
        $text_comment .= '		);';
        $text_comment .= 'MODAL_WINDOW_FLASH_COMMENTS.setHeader("' . get_string('msg_loading', 'block_flash_comments') . '");';
        $text_comment .= 'MODAL_WINDOW_FLASH_COMMENTS.setBody(\'<img src="' . $CFG->wwwroot . '/blocks/flash_comments/imgs/loading.gif" />\');';
        $text_comment .= 'MODAL_WINDOW_FLASH_COMMENTS.render(document.body);';
        $text_comment .= '</script>';

        echo '<div class="flash_comments_history"><ul id="container_flash_messages" class="flash_comments_list">';

        //Build html template
        $tpl_message = '<li><div class="flash_comment_user">%2$s %1$s %7$s - <span class="flash_comment_time">%3$s</span></div>%4$s';
        
        $capability = has_capability('block/flash_comments:managemessages', get_context_instance(CONTEXT_COURSE, $COURSE->id));
        if ($capability) {
            $tpl_message .= '<div class="flash_comment_user_actions">';
            $tpl_message .= '<a href="javascript:;" onclick="delete_instance_flash_comment(%5$s, %6$s, this)">'.
                   '<img src="'.$CFG->pixpath.'/t/delete.gif" class="iconsmall" alt="'. 
                   get_string('delete_comment', 'block_flash_comments') . '" /></a>';   
            $tpl_message .= '</div>';
        }
        $tpl_message .= '</li>';
        //end Build
        
        $rs = get_recordset('flash_comments', 'resourceid', $COURSE->id, 'time DESC', '*');

        $user_guest = get_record('user', 'username', 'guest', '', '', '', '', 'id, picture');
        
        while ($rec = rs_fetch_next_record($rs)) {
            if ($rec->userid > 0 && $rec->userid !== $user_guest->id) {
                $user_comment = get_record('user', 'id', $rec->userid, '', '', '', '', 'id, picture, firstname, lastname');
                $link_to_perfil = true;
            }
            else {
                $user_comment = $user_guest;
                $user_comment->firstname = $rec->username;
                $user_comment->lastname = '';
                $link_to_perfil = false;
            }
            
            $show_mail = $capability ? '- ' . $rec->useremail : '';
            $user_picture = print_user_picture($user_comment, $COURSE->id, $user_comment->picture, false, true, $link_to_perfil);
            $text_comment = sprintf($tpl_message, 
                                        fullname($user_comment), 
                                        $user_picture, 
                                        userdate($rec->time, get_string('strftimedatetime')), 
                                        format_text($rec->comment, FORMAT_MOODLE),
                                        $rec->id,
                                        $COURSE->id,
                                        $show_mail
                                    ) . $text_comment;
        }
        rs_close($rs);
         
        echo $text_comment . '</ul></div>';
    }

    print_footer();

?>