<?php //$Id: block_ocw_rss.php,v 1.0.0.1 2011/01/26 21:58:08 dhbernal Exp $

/*******************************************************************
* Class to link moodle with ocw readers
*
* @author David Herney Bernal Garca
* @version  $Id: block_ocw_rss.php,v 1.0.0.1 2011/01/26 21:58:08 dhbernal Exp $
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @package base
******************************************************************/

/**
 * This class is for a block which defines a block for display on
 * any Moodle page.
 */
 class block_ocw_rss extends block_base {

    function init() {
        $this->title = get_string('blockname', 'block_ocw_rss');
        $this->version = 2011012601;
        $this->cron = 86400; /// Set min time between cron executions to 86400 secs (1 day)
    }

    function applicable_formats() {
        return array('site' => true);
    }

    function specialization() {
        $this->title = get_string('title', 'block_ocw_rss');
    }

    function get_content() {
        global $CFG;

        if($this->content !== NULL) {
            return $this->content;
        }

        $this->content = new stdClass;
        $this->content->text   = '';
        $this->content->footer = '';

        $output = '<a href="' . $CFG->wwwroot . '/blocks/ocw_rss/rss.php" target="_blank"><img src="' . $CFG->pixpath . '/i/rss.gif" /> ' . get_string('view_rss', 'block_ocw_rss') . '</a>';

        $this->content->text = $output;
        return $this->content;
    }

    function instance_allow_multiple() {
        return false;
    }

    function has_config() {
        return true;
    }

    function instance_allow_config() {
        return false;
    }

    // cron function, used to refresh all the RSS feeds from Moodle cron
    function cron() {

        global $CFG, $COURSE;

    /// We are going to measure execution times
        $starttime =  microtime();

    /// And we have one initial $status
        $status = true;

    /// We require some stuff
        require_once($CFG->libdir .'/rsslib.php');
        require_once(MAGPIE_DIR .'rss_fetch.inc');

        if (!defined('MAGPIE_OUTPUT_ENCODING')) {
            define('MAGPIE_OUTPUT_ENCODING', 'utf-8');  // see bug 3107
        }

        //Get the XML contents
        $result = $this->ocw_rss_feed();
        //Save the XML contents to file
        if (!empty($result)) {
            $status = rss_save_file("block_ocw_rss", $COURSE, $result);
        }
        if (debugging()) {
            if (empty($result)) {
                echo "Courses list (empty) ";
            } else {
                if (!empty($status)) {
                    echo "OCW RSS file OK ";
                } else {
                    echo "OCW RSS file FAIL ";
                }
            }
        }

    /// Show times
        mtrace('Created OCW RSS file (took ' . microtime_diff($starttime, microtime()) . ' seconds)');

    /// And return $status
        return $status;
    }
    
    // Deletes the RSS site file
    function ocw_rss_delete_file() {
        global $CFG, $COURSE;
        
        $rssfile = rss_file_name('block_ocw_rss', $COURSE);
        if (file_exists($rssfile)) {
            return unlink($rssfile);
        } else {
            return true;
        }
    }


    //This function returns the rss XML code for every item
    //This function was custom because OCW require a special XML
    function ocw_rss_feed_items($resource = false) {

        global $CFG, $COURSE;

        $status = true;

        if (!$site = get_site()) {
            $status = false;
        }

        $result = '';

        if ($status) {
            $columns = array('id', 'fullname', 'summary', 'timecreated', 'timemodified', 'lang', 'visible');
            $keywords_column = '';
            if (!empty($CFG->block_ocw_rss_keywords)) {
                $keywords_column = $CFG->block_ocw_rss_keywords;
                $columns[] = $CFG->block_ocw_rss_keywords;
            }

            if ($courses = get_courses_wmanagers('all',
                                                'c.sortorder ASC',
                                                $columns)) {
                $item = NULL;
    
                $licence = isset($CFG->block_ocw_rss_licence) ? format_text($CFG->block_ocw_rss_licence, FORMAT_PLAIN) : '';

                foreach ($courses as $rec) {
					if ($rec->visible != 1) {
						continue;
					}
					
                    unset($item);
                    $item->title = $rec->fullname;
                    $item->link = $CFG->wwwroot."/course/view.php?id=".$rec->id;
                    $item->description = format_text($rec->summary, FORMAT_PLAIN);
                    $item->date = date('Y-m-d\TH:i:sO', $rec->timemodified);
                    $item->type = 'Course';
                    $item->format = 'text/html';
                    $item->language = !empty($rec->lang) ? $rec->lang : !empty($site->lang) ? $site->lang : $CFG->lang;
                    $item->pubdate = $rec->timecreated;
                    $item->keywords = array();
                    
                    if (!empty($keywords_column) && !empty($rec->$keywords_column)) {
                        $words = explode(',', $rec->$keywords_column);
                        foreach ($words as $word) {
                            $item->keywords[] = trim($word);
                        }
                    }

                    if ($resource) {
                        //rss_simple_tag function is in bottom of this file because it not exist in moodle rss library
                        $result .= rss_simple_tag('rdf:li', 4, true, array('rdf:resource'=>$item->link));
                    }
                    else {
                        $result .= rss_start_tag('item', 1, true, array('rdf:about'=>$item->link));
        
                        $result .= rss_full_tag('title', 2, false, strip_tags($item->title));
                        $result .= rss_full_tag('link', 2, false, $item->link);
                        $result .= rss_full_tag('pubDate', 2, false,gmdate('D, d M Y H:i:s',$item->pubdate).' GMT');
                        $result .= rss_full_tag('description', 2, false, $item->description);
                        $result .= rss_full_tag('guid', 2, false, $item->link,array('isPermaLink' => 'true'));
                        
                        if ($rec->managers && is_array($rec->managers)) {
                            foreach ($rec->managers as $manager) {
                                $result .= rss_full_tag('dc:creator', 2, false, fullname($manager->user));
                            }
                        }

                        foreach ($item->keywords as $word) {
                            $result .= rss_full_tag('dc:subject', 2, false, $word);
                        }

                        if (!empty($licence)) {
                            $result .= rss_full_tag('dc:rights', 2, false, $licence);
                        }
        
                        $result .= rss_full_tag('dc:date', 2, false, $item->date);
                        $result .= rss_full_tag('dc:type', 2, false, $item->type);
                        $result .= rss_full_tag('dc:format', 2, false, $item->format);
                        
                        if (!empty($item->language)) {
                            $result .= rss_full_tag('dc:language', 2, false, substr($item->language, 0, 2));
                        }

                        $result .= rss_end_tag('item', 1, true);
                    }
                }
            }
        }
        return $result;
    }

    //This function return the XML rss contents
    //It returns false if something is wrong
    function ocw_rss_feed() {

        global $CFG;

        $status = true;

        //Check CFG->enablerssfeeds
        if (empty($CFG->enablerssfeeds)) {
            debugging("DISABLED (admin variables)");
        //It's working so we start...
        }
        else {
            $items = $this->ocw_rss_feed_items();

            //Now, if items, we begin building the structure
            if (!empty($items)) {
                
                //First all rss feeds common headers
                $header = $this->ocw_rss_header();
                //Now all rss feeds common footers
                if (!empty($header)) {
                    $footer = $this->ocw_rss_footer();
                }
                //Now, if everything is ok, concatenate it
                if (!empty($header) && !empty($footer)) {
                    $status = $header.$items.$footer;
                } 
                else {
                    $status = false;
                }
            } 
            else {
                $status = false;
            }
        }
        return $status;
    }

    function ocw_rss_header() {
        global $CFG;

        $status = true;
        $result = "";
    
        if (!$site = get_site()) {
            $status = false;
        }
    
        if ($status) {
    
            //Calculate title, link and description
            $title = format_string($site->fullname);
            $link = $CFG->wwwroot . '/';
            $description = format_string($site->summary, FORMAT_PLAIN);
    
            //xml headers
            $result .= "<?xml version=\"1.0\"?>\n";
            $result .= "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
            $result .= "    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n";
            $result .= "    xmlns:syn=\"http://purl.org/rss/1.0/modules/syndication/\"\n";
            $result .= "    xmlns:cc=\"http://web.resource.org/cc/\"\n";
            $result .= "    xmlns=\"http://purl.org/rss/1.0/\">\n";
            
            $url_rss = $CFG->wwwroot . "/blocks/ocw_rss/rss.php";
            //open the channel
            $result .= rss_start_tag('channel', 1, true, array("rdf:about" => $url_rss));
            
            //write channel info
            $result .= rss_full_tag('title', 2, false, strip_tags($title));
            $result .= rss_full_tag('link', 2, false, $link);
            $result .= rss_full_tag('description', 2, false, $description);
            $result .= rss_full_tag('generator', 2, false, 'Moodle');
            if (!empty($site->lang)) {
                $result .= rss_full_tag('language', 2, false, substr($site->lang, 0, 2));
            }
            $today = getdate();
            $result .= rss_full_tag('copyright', 2, false, '&#169; '. $today['year'] .' '. format_string($site->fullname));
    
            //List of fount elements
            $result .= rss_start_tag('items', 2, true);
            $result .= rss_start_tag('rdf:Seq', 3, true);
            $result .= $this->ocw_rss_feed_items(true);
            $result .= rss_end_tag('rdf:Seq', 3, true);
            $result .= rss_end_tag('items', 2, true);
    
            //Close the chanel
            $result .= rss_end_tag('channel', 1, true);
        }
    
        if (!$status) {
            return false;
        } else {
            return $result;
        }
    }

    function ocw_rss_footer() {
        global $CFG;

        $status = true;
        $result = '';
    
        ////Close the rdf tag
        $result .= '</rdf:RDF>';
    
        return $result;
    }
}

//Return the xml simple tag
function rss_simple_tag($tag,$level=0,$endline=false,$attributes=null) {
    if ($endline) {
       $endchar = "\n";
    } else {
       $endchar = "";
    }
    $attrstring = '';
    if (!empty($attributes) && is_array($attributes)) {
        foreach ($attributes as $key => $value) {
            $attrstring .= " ".$key."=\"".$value."\"";
        }
    }
    return str_repeat(" ",$level*2)."<".$tag.$attrstring." />".$endchar;
}

?>