<?php
  
  /**
  * Search with google services
  *
  * 
  * @package goosearch
  * @subpackage goosearch
  * @author: dhbernal
  * @date: 2010-10-13
  */
     
  class block_goosearch extends block_base {
    
    function init() {
      $this->title = get_string('blockname', 'block_goosearch');
      $this->version = 2010101300;
    } //init  
    
    // only one instance of this block is required
    function instance_allow_multiple() {
      return false;
    } //instance_allow_multiple

    function specialization() {
        $this->title = get_string('title', 'block_goosearch');
    }

    function has_config() {
      return false;
    } //has_config
      
    function get_content() {
      global $CFG;

      //cache block contents
      if ($this->content !== NULL) {
        return $this->content;
      } //if
      
      $this->content = new stdClass;

      //Se crean las variables que se necesitaran en el include.
      $q = optional_param('q', '', PARAM_TEXT);

      //Se utiliza un include_once por si, por alguna razn el bloque se llama dos veces en una pgina solo se incluya una vez el html
      //ToDo: probar si funciona el llamado solo una vez
      include_once $CFG->dirroot . '/blocks/goosearch/include_code.php';

      $this->content->text = '<div id="searchcontrol">' . get_string('loading', 'block_goosearch') . '</div>';

      //no footer, thanks
      $this->content->footer = '';
      
      return $this->content;      
    } //get_content
    
  }

?>
